package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AnatomicalHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫀",
        description = "anatomical heart",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("anatomical-heart", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji People & Body: body-parts: anatomical heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AnatomicalHeart: Emoji get() = _AnatomicalHeart
