package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonPlayingHandball: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤾",
        description = "person playing handball",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("person-playing-handball", "handball"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person playing handball.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonPlayingHandball: SkinTone1Emoji get() = _PersonPlayingHandball

/**
 * Alias to emoji [PersonPlayingHandball] (People & Body: person-sport: person playing handball).
*/
public val Emoji.Companion.Handball: SkinTone1Emoji get() = _PersonPlayingHandball
