package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LyingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤥",
        description = "lying face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("lying-face", "liar"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: lying face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LyingFace: Emoji get() = _LyingFace

/**
 * Alias to emoji [LyingFace] (Smileys & Emotion: face-neutral-skeptical: lying face).
*/
public val Emoji.Companion.Liar: Emoji get() = _LyingFace
