package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BackArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔙",
        description = "BACK arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("back-arrow", "back", "arrow-back"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: BACK arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BackArrow: Emoji get() = _BackArrow

/**
 * Alias to emoji [BackArrow] (Symbols: arrow: BACK arrow).
*/
public val Emoji.Companion.Back: Emoji get() = _BackArrow

/**
 * Alias to emoji [BackArrow] (Symbols: arrow: BACK arrow).
*/
public val Emoji.Companion.ArrowBack: Emoji get() = _BackArrow
