package org.kodein.emoji.travel_places.transport_air

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmallAirplane: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛩️",
        description = "small airplane",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("small-airplane", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-air: small airplane.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmallAirplane: Emoji get() = _SmallAirplane
