package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAustria: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇹",
        description = "flag: Austria",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-austria", "austria-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Austria.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAustria: Emoji get() = _FlagAustria

/**
 * Alias to emoji [FlagAustria] (Flags: country-flag: flag: Austria).
*/
public val Emoji.Companion.AustriaFlag: Emoji get() = _FlagAustria
