package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagReUnion: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇷🇪",
        description = "flag: Réunion",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-re-union", "re-union-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Réunion.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagReUnion: Emoji get() = _FlagReUnion

/**
 * Alias to emoji [FlagReUnion] (Flags: country-flag: flag: Réunion).
*/
public val Emoji.Companion.ReUnionFlag: Emoji get() = _FlagReUnion
