package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSingapore: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇬",
        description = "flag: Singapore",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-singapore", "singapore-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Singapore.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSingapore: Emoji get() = _FlagSingapore

/**
 * Alias to emoji [FlagSingapore] (Flags: country-flag: flag: Singapore).
*/
public val Emoji.Companion.SingaporeFlag: Emoji get() = _FlagSingapore
