package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagThailand: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇭",
        description = "flag: Thailand",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-thailand", "thailand-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Thailand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagThailand: Emoji get() = _FlagThailand

/**
 * Alias to emoji [FlagThailand] (Flags: country-flag: flag: Thailand).
*/
public val Emoji.Companion.ThailandFlag: Emoji get() = _FlagThailand
