package org.kodein.emoji.food_drink.food_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodMarine() {
    add(intArrayOf(0x1f990), _Shrimp)
    add(intArrayOf(0x1f99e), _Lobster)
    add(intArrayOf(0x1f980), _Crab)
    add(intArrayOf(0x1f991), _Squid)
    add(intArrayOf(0x1f9aa), _Oyster)
}

internal fun MutableList<Emoji>.addAllFoodMarine() {
    add(_Shrimp)
    add(_Lobster)
    add(_Crab)
    add(_Squid)
    add(_Oyster)
}

/**
 * All Emoji of the Food & Drink: food-marine subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodMarine(): List<Emoji> =
    ArrayList<Emoji>(5).apply { addAllFoodMarine() }
