package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrossedSwords: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚔️",
        description = "crossed swords",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("crossed-swords", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: crossed swords.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrossedSwords: Emoji get() = _CrossedSwords
