package org.kodein.emoji.people_body

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.people_body.hand_fingers_partial.*
import org.kodein.emoji.people_body.person_role.*
import org.kodein.emoji.people_body.hands.*
import org.kodein.emoji.people_body.body_parts.*
import org.kodein.emoji.people_body.hand_fingers_closed.*
import org.kodein.emoji.people_body.hand_fingers_open.*
import org.kodein.emoji.people_body.person_resting.*
import org.kodein.emoji.people_body.person_sport.*
import org.kodein.emoji.people_body.hand_prop.*
import org.kodein.emoji.people_body.person.*
import org.kodein.emoji.people_body.person_symbol.*
import org.kodein.emoji.people_body.person_activity.*
import org.kodein.emoji.people_body.person_gesture.*
import org.kodein.emoji.people_body.hand_single_finger.*
import org.kodein.emoji.people_body.person_fantasy.*
import org.kodein.emoji.people_body.family.*


internal fun EmojiFinder.addAllPeopleBody() {
    addAllHandFingersPartial()
    addAllPersonRole()
    addAllHands()
    addAllBodyParts()
    addAllHandFingersClosed()
    addAllHandFingersOpen()
    addAllPersonResting()
    addAllPersonSport()
    addAllHandProp()
    addAllPerson()
    addAllPersonSymbol()
    addAllPersonActivity()
    addAllPersonGesture()
    addAllHandSingleFinger()
    addAllPersonFantasy()
    addAllFamily()
}

internal fun MutableList<Emoji>.addAllPeopleBody() {
    addAllHandFingersPartial()
    addAllPersonRole()
    addAllHands()
    addAllBodyParts()
    addAllHandFingersClosed()
    addAllHandFingersOpen()
    addAllPersonResting()
    addAllPersonSport()
    addAllHandProp()
    addAllPerson()
    addAllPersonSymbol()
    addAllPersonActivity()
    addAllPersonGesture()
    addAllHandSingleFinger()
    addAllPersonFantasy()
    addAllFamily()
}

/**
 * All Emoji of the People & Body group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPeopleBody(): List<Emoji> =
    ArrayList<Emoji>(385).apply { addAllPeopleBody() }

internal fun allPeopleBodySubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "hand_fingers_partial" to { Emoji.allHandFingersPartial() },
        "person_role" to { Emoji.allPersonRole() },
        "hands" to { Emoji.allHands() },
        "body_parts" to { Emoji.allBodyParts() },
        "hand_fingers_closed" to { Emoji.allHandFingersClosed() },
        "hand_fingers_open" to { Emoji.allHandFingersOpen() },
        "person_resting" to { Emoji.allPersonResting() },
        "person_sport" to { Emoji.allPersonSport() },
        "hand_prop" to { Emoji.allHandProp() },
        "person" to { Emoji.allPerson() },
        "person_symbol" to { Emoji.allPersonSymbol() },
        "person_activity" to { Emoji.allPersonActivity() },
        "person_gesture" to { Emoji.allPersonGesture() },
        "hand_single_finger" to { Emoji.allHandSingleFinger() },
        "person_fantasy" to { Emoji.allPersonFantasy() },
        "family" to { Emoji.allFamily() },
    )
