package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FearfulFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😨",
        description = "fearful face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fearful-face", "scared"),
        emoticons = listOf("D-:"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: fearful face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FearfulFace: Emoji get() = _FearfulFace

/**
 * Alias to emoji [FearfulFace] (Smileys & Emotion: face-concerned: fearful face).
*/
public val Emoji.Companion.Scared: Emoji get() = _FearfulFace
