package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithOpenHands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤗",
        description = "smiling face with open hands",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("smiling-face-with-open-hands", "hug-face"),
        emoticons = listOf("\\(^o^)/"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: smiling face with open hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithOpenHands: Emoji get() = _SmilingFaceWithOpenHands

/**
 * Alias to emoji [SmilingFaceWithOpenHands] (Smileys & Emotion: face-hand: smiling face with open hands).
*/
public val Emoji.Companion.HugFace: Emoji get() = _SmilingFaceWithOpenHands
