package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FourOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕓",
        description = "four o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("four-oclock", "four-o-clock"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: four o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FourOclock: Emoji get() = _FourOclock

/**
 * Alias to emoji [FourOclock] (Travel & Places: time: four o’clock).
*/
public val Emoji.Companion.FourOClock: Emoji get() = _FourOclock
