package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EmptyNest: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪹",
        description = "empty nest",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("empty-nest", "nest"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: empty nest.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EmptyNest: Emoji get() = _EmptyNest

/**
 * Alias to emoji [EmptyNest] (Animals & Nature: plant-other: empty nest).
*/
public val Emoji.Companion.Nest: Emoji get() = _EmptyNest
