package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAfghanistan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇫",
        description = "flag: Afghanistan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-afghanistan", "afghanistan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Afghanistan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAfghanistan: Emoji get() = _FlagAfghanistan

/**
 * Alias to emoji [FlagAfghanistan] (Flags: country-flag: flag: Afghanistan).
*/
public val Emoji.Companion.AfghanistanFlag: Emoji get() = _FlagAfghanistan
