package org.kodein.emoji.food_drink.food_vegetable

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodVegetable() {
    add(intArrayOf(0x1f336, 0xfe0f), _HotPepper)
    add(intArrayOf(0x1f336), _HotPepper)
    add(intArrayOf(0x1fada), _GingerRoot)
    add(intArrayOf(0x1f955), _Carrot)
    add(intArrayOf(0x1f9c5), _Onion)
    add(intArrayOf(0x1f33d), _EarOfCorn)
    add(intArrayOf(0x1f966), _Broccoli)
    add(intArrayOf(0x1f952), _Cucumber)
    add(intArrayOf(0x1f96c), _LeafyGreen)
    add(intArrayOf(0x1fadb), _PeaPod)
    add(intArrayOf(0x1fad1), _BellPepper)
    add(intArrayOf(0x1f951), _Avocado)
    add(intArrayOf(0x1f346), _Eggplant)
    add(intArrayOf(0x1f9c4), _Garlic)
    add(intArrayOf(0x1f954), _Potato)
    add(intArrayOf(0x1fad8), _Beans)
    add(intArrayOf(0x1f330), _Chestnut)
    add(intArrayOf(0x1f95c), _Peanuts)
    add(intArrayOf(0x1f344, 0x200d, 0x1f7eb), _BrownMushroom)
}

internal fun MutableList<Emoji>.addAllFoodVegetable() {
    add(_HotPepper)
    add(_GingerRoot)
    add(_Carrot)
    add(_Onion)
    add(_EarOfCorn)
    add(_Broccoli)
    add(_Cucumber)
    add(_LeafyGreen)
    add(_PeaPod)
    add(_BellPepper)
    add(_Avocado)
    add(_Eggplant)
    add(_Garlic)
    add(_Potato)
    add(_Beans)
    add(_Chestnut)
    add(_Peanuts)
    add(_BrownMushroom)
}

/**
 * All Emoji of the Food & Drink: food-vegetable subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodVegetable(): List<Emoji> =
    ArrayList<Emoji>(18).apply { addAllFoodVegetable() }
