package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Handbag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👜",
        description = "handbag",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("handbag", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: handbag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Handbag: Emoji get() = _Handbag
