package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MusicalNote: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎵",
        description = "musical note",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("musical-note", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: music: musical note.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MusicalNote: Emoji get() = _MusicalNote
