package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CardIndex: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📇",
        description = "card index",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("card-index", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: card index.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CardIndex: Emoji get() = _CardIndex
