package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FuneralUrn: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚱️",
        description = "funeral urn",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("funeral-urn", "urn"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: other-object: funeral urn.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FuneralUrn: Emoji get() = _FuneralUrn

/**
 * Alias to emoji [FuneralUrn] (Objects: other-object: funeral urn).
*/
public val Emoji.Companion.Urn: Emoji get() = _FuneralUrn
