package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MutedSpeaker: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔇",
        description = "muted speaker",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("muted-speaker", "mute"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: sound: muted speaker.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MutedSpeaker: Emoji get() = _MutedSpeaker

/**
 * Alias to emoji [MutedSpeaker] (Objects: sound: muted speaker).
*/
public val Emoji.Companion.Mute: Emoji get() = _MutedSpeaker
