package org.kodein.emoji.people_body.hands

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PalmsUpTogether: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤲",
        description = "palms up together",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("palms-up-together", "palms-up"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hands: palms up together.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PalmsUpTogether: SkinTone1Emoji get() = _PalmsUpTogether

/**
 * Alias to emoji [PalmsUpTogether] (People & Body: hands: palms up together).
*/
public val Emoji.Companion.PalmsUp: SkinTone1Emoji get() = _PalmsUpTogether
