package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _WomanDancing: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💃",
        description = "woman dancing",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("woman-dancing", "dancer-woman"),
        emoticons = listOf("♪┏(･o･)┛♪"),
        notoAnimated = true,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: woman dancing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomanDancing: SkinTone1Emoji get() = _WomanDancing

/**
 * Alias to emoji [WomanDancing] (People & Body: person-activity: woman dancing).
*/
public val Emoji.Companion.DancerWoman: SkinTone1Emoji get() = _WomanDancing
