package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PregnantPerson: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫄",
        description = "pregnant person",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("pregnant-person", "pregnant"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: pregnant person.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PregnantPerson: SkinTone1Emoji get() = _PregnantPerson

/**
 * Alias to emoji [PregnantPerson] (People & Body: person-role: pregnant person).
*/
public val Emoji.Companion.Pregnant: SkinTone1Emoji get() = _PregnantPerson
