package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithTongue: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😛",
        description = "face with tongue",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-with-tongue", "stuck-out-tongue"),
        emoticons = listOf(":P", ":p", ":-P", ":-p"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-tongue: face with tongue.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithTongue: Emoji get() = _FaceWithTongue

/**
 * Alias to emoji [FaceWithTongue] (Smileys & Emotion: face-tongue: face with tongue).
*/
public val Emoji.Companion.StuckOutTongue: Emoji get() = _FaceWithTongue
