package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SquintingFaceWithTongue: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😝",
        description = "squinting face with tongue",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("squinting-face-with-tongue", "squinting-tongue"),
        emoticons = listOf(">q<"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-tongue: squinting face with tongue.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SquintingFaceWithTongue: Emoji get() = _SquintingFaceWithTongue

/**
 * Alias to emoji [SquintingFaceWithTongue] (Smileys & Emotion: face-tongue: squinting face with tongue).
*/
public val Emoji.Companion.SquintingTongue: Emoji get() = _SquintingFaceWithTongue
