package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RunningShirt: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎽",
        description = "running shirt",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("running-shirt", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: sport: running shirt.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RunningShirt: Emoji get() = _RunningShirt
