package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEgypt: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇬",
        description = "flag: Egypt",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-egypt", "egypt-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Egypt.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEgypt: Emoji get() = _FlagEgypt

/**
 * Alias to emoji [FlagEgypt] (Flags: country-flag: flag: Egypt).
*/
public val Emoji.Companion.EgyptFlag: Emoji get() = _FlagEgypt
