package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGambia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇲",
        description = "flag: Gambia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-gambia", "gambia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Gambia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGambia: Emoji get() = _FlagGambia

/**
 * Alias to emoji [FlagGambia] (Flags: country-flag: flag: Gambia).
*/
public val Emoji.Companion.GambiaFlag: Emoji get() = _FlagGambia
