package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGreece: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇷",
        description = "flag: Greece",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-greece", "greece-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Greece.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGreece: Emoji get() = _FlagGreece

/**
 * Alias to emoji [FlagGreece] (Flags: country-flag: flag: Greece).
*/
public val Emoji.Companion.GreeceFlag: Emoji get() = _FlagGreece
