package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSpain: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇸",
        description = "flag: Spain",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-spain", "spain-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Spain.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSpain: Emoji get() = _FlagSpain

/**
 * Alias to emoji [FlagSpain] (Flags: country-flag: flag: Spain).
*/
public val Emoji.Companion.SpainFlag: Emoji get() = _FlagSpain
