package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OpenMailboxWithLoweredFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📭",
        description = "open mailbox with lowered flag",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("open-mailbox-with-lowered-flag", "open-mailbox-with-lowered"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: mail: open mailbox with lowered flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OpenMailboxWithLoweredFlag: Emoji get() = _OpenMailboxWithLoweredFlag

/**
 * Alias to emoji [OpenMailboxWithLoweredFlag] (Objects: mail: open mailbox with lowered flag).
*/
public val Emoji.Companion.OpenMailboxWithLowered: Emoji get() = _OpenMailboxWithLoweredFlag
