package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PalmDownHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫳",
        description = "palm down hand",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("palm-down-hand", "palm-down", "drop"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: palm down hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PalmDownHand: SkinTone1Emoji get() = _PalmDownHand

/**
 * Alias to emoji [PalmDownHand] (People & Body: hand-fingers-open: palm down hand).
*/
public val Emoji.Companion.PalmDown: SkinTone1Emoji get() = _PalmDownHand

/**
 * Alias to emoji [PalmDownHand] (People & Body: hand-fingers-open: palm down hand).
*/
public val Emoji.Companion.Drop: SkinTone1Emoji get() = _PalmDownHand
