package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AngerSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💢",
        description = "anger symbol",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("anger-symbol", "anger"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: anger symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AngerSymbol: Emoji get() = _AngerSymbol

/**
 * Alias to emoji [AngerSymbol] (Smileys & Emotion: emotion: anger symbol).
*/
public val Emoji.Companion.Anger: Emoji get() = _AngerSymbol
