package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAlphanum() {
    add(intArrayOf(0x1f170, 0xfe0f), _AButtonBloodType)
    add(intArrayOf(0x1f170), _AButtonBloodType)
    add(intArrayOf(0x1f18e), _AbButtonBloodType)
    add(intArrayOf(0x1f171, 0xfe0f), _BButtonBloodType)
    add(intArrayOf(0x1f171), _BButtonBloodType)
    add(intArrayOf(0x1f17e, 0xfe0f), _OButtonBloodType)
    add(intArrayOf(0x1f17e), _OButtonBloodType)
    add(intArrayOf(0x1f191), _ClButton)
    add(intArrayOf(0x1f198), _SosButton)
    add(intArrayOf(0x1f250), _JapaneseBargainButton)
    add(intArrayOf(0x3299, 0xfe0f), _JapaneseSecretButton)
    add(intArrayOf(0x3299), _JapaneseSecretButton)
    add(intArrayOf(0x3297, 0xfe0f), _JapaneseCongratulationsButton)
    add(intArrayOf(0x3297), _JapaneseCongratulationsButton)
    add(intArrayOf(0x1f234), _JapanesePassingGradeButton)
    add(intArrayOf(0x1f235), _JapaneseNoVacancyButton)
    add(intArrayOf(0x1f239), _JapaneseDiscountButton)
    add(intArrayOf(0x1f232), _JapaneseProhibitedButton)
    add(intArrayOf(0x1f251), _JapaneseAcceptableButton)
    add(intArrayOf(0x1f236), _JapaneseNotFreeOfChargeButton)
    add(intArrayOf(0x1f21a), _JapaneseFreeOfChargeButton)
    add(intArrayOf(0x1f238), _JapaneseApplicationButton)
    add(intArrayOf(0x1f23a), _JapaneseOpenForBusinessButton)
    add(intArrayOf(0x1f237, 0xfe0f), _JapaneseMonthlyAmountButton)
    add(intArrayOf(0x1f237), _JapaneseMonthlyAmountButton)
    add(intArrayOf(0x1f19a), _VsButton)
    add(intArrayOf(0x1f22f), _JapaneseReservedButton)
    add(intArrayOf(0x1f195), _NewButton)
    add(intArrayOf(0x1f193), _FreeButton)
    add(intArrayOf(0x1f199), _UpButton)
    add(intArrayOf(0x1f197), _OkButton)
    add(intArrayOf(0x1f192), _CoolButton)
    add(intArrayOf(0x1f196), _NgButton)
    add(intArrayOf(0x2139, 0xfe0f), _Information)
    add(intArrayOf(0x2139), _Information)
    add(intArrayOf(0x1f17f, 0xfe0f), _PButton)
    add(intArrayOf(0x1f17f), _PButton)
    add(intArrayOf(0x1f201), _JapaneseHereButton)
    add(intArrayOf(0x1f202, 0xfe0f), _JapaneseServiceChargeButton)
    add(intArrayOf(0x1f202), _JapaneseServiceChargeButton)
    add(intArrayOf(0x1f233), _JapaneseVacancyButton)
    add(intArrayOf(0x1f523), _InputSymbols)
    add(intArrayOf(0x1f524), _InputLatinLetters)
    add(intArrayOf(0x1f520), _InputLatinUppercase)
    add(intArrayOf(0x1f521), _InputLatinLowercase)
    add(intArrayOf(0x1f522), _InputNumbers)
    add(intArrayOf(0x24c2, 0xfe0f), _CircledM)
    add(intArrayOf(0x24c2), _CircledM)
    add(intArrayOf(0x1f194), _IdButton)
}

internal fun MutableList<Emoji>.addAllAlphanum() {
    add(_AButtonBloodType)
    add(_AbButtonBloodType)
    add(_BButtonBloodType)
    add(_OButtonBloodType)
    add(_ClButton)
    add(_SosButton)
    add(_JapaneseBargainButton)
    add(_JapaneseSecretButton)
    add(_JapaneseCongratulationsButton)
    add(_JapanesePassingGradeButton)
    add(_JapaneseNoVacancyButton)
    add(_JapaneseDiscountButton)
    add(_JapaneseProhibitedButton)
    add(_JapaneseAcceptableButton)
    add(_JapaneseNotFreeOfChargeButton)
    add(_JapaneseFreeOfChargeButton)
    add(_JapaneseApplicationButton)
    add(_JapaneseOpenForBusinessButton)
    add(_JapaneseMonthlyAmountButton)
    add(_VsButton)
    add(_JapaneseReservedButton)
    add(_NewButton)
    add(_FreeButton)
    add(_UpButton)
    add(_OkButton)
    add(_CoolButton)
    add(_NgButton)
    add(_Information)
    add(_PButton)
    add(_JapaneseHereButton)
    add(_JapaneseServiceChargeButton)
    add(_JapaneseVacancyButton)
    add(_InputSymbols)
    add(_InputLatinLetters)
    add(_InputLatinUppercase)
    add(_InputLatinLowercase)
    add(_InputNumbers)
    add(_CircledM)
    add(_IdButton)
}

/**
 * All Emoji of the Symbols: alphanum subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAlphanum(): List<Emoji> =
    ArrayList<Emoji>(39).apply { addAllAlphanum() }
