package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteQuestionMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❔",
        description = "white question mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-question-mark", "question-mark-white"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: punctuation: white question mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteQuestionMark: Emoji get() = _WhiteQuestionMark

/**
 * Alias to emoji [WhiteQuestionMark] (Symbols: punctuation: white question mark).
*/
public val Emoji.Companion.QuestionMarkWhite: Emoji get() = _WhiteQuestionMark
