package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LatinCross: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✝️",
        description = "latin cross",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("latin-cross", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: religion: latin cross.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LatinCross: Emoji get() = _LatinCross
