package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomensRoom: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚺",
        description = "women’s room",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("womens-room", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: women’s room.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomensRoom: Emoji get() = _WomensRoom
