package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Fire: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔥",
        description = "fire",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fire", "burn", "lit"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: fire.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Fire: Emoji get() = _Fire

/**
 * Alias to emoji [Fire] (Travel & Places: sky & weather: fire).
*/
public val Emoji.Companion.Burn: Emoji get() = _Fire

/**
 * Alias to emoji [Fire] (Travel & Places: sky & weather: fire).
*/
public val Emoji.Companion.Lit: Emoji get() = _Fire
