package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HourglassDone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⌛",
        description = "hourglass done",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hourglass-done", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: time: hourglass done.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HourglassDone: Emoji get() = _HourglassDone
