package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagHongKongSarChina: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇰",
        description = "flag: Hong Kong SAR China",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-hong-kong-sar-china", "hong-kong-sar-china-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Hong Kong SAR China.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagHongKongSarChina: Emoji get() = _FlagHongKongSarChina

/**
 * Alias to emoji [FlagHongKongSarChina] (Flags: country-flag: flag: Hong Kong SAR China).
*/
public val Emoji.Companion.HongKongSarChinaFlag: Emoji get() = _FlagHongKongSarChina
