package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFlag() {
    add(intArrayOf(0x1f3c1), _ChequeredFlag)
    add(intArrayOf(0x1f6a9), _TriangularFlag)
    add(intArrayOf(0x1f38c), _CrossedFlags)
    add(intArrayOf(0x1f3f4), _BlackFlag)
    add(intArrayOf(0x1f3f3, 0xfe0f), _WhiteFlag)
    add(intArrayOf(0x1f3f3), _WhiteFlag)
    add(intArrayOf(0x1f3f3, 0xfe0f, 0x200d, 0x1f308), _RainbowFlag)
    add(intArrayOf(0x1f3f3, 0x200d, 0x1f308), _RainbowFlag)
    add(intArrayOf(0x1f3f3, 0xfe0f, 0x200d, 0x26a7, 0xfe0f), _TransgenderFlag)
    add(intArrayOf(0x1f3f3, 0x200d, 0x26a7, 0xfe0f), _TransgenderFlag)
    add(intArrayOf(0x1f3f3, 0xfe0f, 0x200d, 0x26a7), _TransgenderFlag)
    add(intArrayOf(0x1f3f3, 0x200d, 0x26a7), _TransgenderFlag)
    add(intArrayOf(0x1f3f4, 0x200d, 0x2620, 0xfe0f), _PirateFlag)
    add(intArrayOf(0x1f3f4, 0x200d, 0x2620), _PirateFlag)
}

internal fun MutableList<Emoji>.addAllFlag() {
    add(_ChequeredFlag)
    add(_TriangularFlag)
    add(_CrossedFlags)
    add(_BlackFlag)
    add(_WhiteFlag)
    add(_RainbowFlag)
    add(_TransgenderFlag)
    add(_PirateFlag)
}

/**
 * All Emoji of the Flags: flag subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFlag(): List<Emoji> =
    ArrayList<Emoji>(8).apply { addAllFlag() }
