package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LotionBottle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧴",
        description = "lotion bottle",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("lotion-bottle", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: household: lotion bottle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LotionBottle: Emoji get() = _LotionBottle
