package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DivingMask: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤿",
        description = "diving mask",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("diving-mask", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: sport: diving mask.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DivingMask: Emoji get() = _DivingMask
