package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEquatorialGuinea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇶",
        description = "flag: Equatorial Guinea",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-equatorial-guinea", "equatorial-guinea-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Equatorial Guinea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEquatorialGuinea: Emoji get() = _FlagEquatorialGuinea

/**
 * Alias to emoji [FlagEquatorialGuinea] (Flags: country-flag: flag: Equatorial Guinea).
*/
public val Emoji.Companion.EquatorialGuineaFlag: Emoji get() = _FlagEquatorialGuinea
