package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TropicalDrink: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍹",
        description = "tropical drink",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tropical-drink", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Food & Drink: drink: tropical drink.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TropicalDrink: Emoji get() = _TropicalDrink
