package org.kodein.emoji.objects.musical_instrument

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMusicalInstrument() {
    add(intArrayOf(0x1f3b9), _MusicalKeyboard)
    add(intArrayOf(0x1f3b7), _Saxophone)
    add(intArrayOf(0x1f3ba), _Trumpet)
    add(intArrayOf(0x1f3b8), _Guitar)
    add(intArrayOf(0x1fa95), _Banjo)
    add(intArrayOf(0x1f3bb), _Violin)
    add(intArrayOf(0x1fa98), _LongDrum)
    add(intArrayOf(0x1f941), _Drum)
    add(intArrayOf(0x1fa87), _Maracas)
    add(intArrayOf(0x1fa88), _Flute)
    add(intArrayOf(0x1fa97), _Accordion)
}

internal fun MutableList<Emoji>.addAllMusicalInstrument() {
    add(_MusicalKeyboard)
    add(_Saxophone)
    add(_Trumpet)
    add(_Guitar)
    add(_Banjo)
    add(_Violin)
    add(_LongDrum)
    add(_Drum)
    add(_Maracas)
    add(_Flute)
    add(_Accordion)
}

/**
 * All Emoji of the Objects: musical-instrument subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMusicalInstrument(): List<Emoji> =
    ArrayList<Emoji>(11).apply { addAllMusicalInstrument() }
