package org.kodein.emoji.people_body.hand_prop

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandProp() {
    add(intArrayOf(0x270d, 0xfe0f), _WritingHand)
    add(intArrayOf(0x270d), _WritingHand)
    addVariations(intArrayOf(0x270d, 0x0), _WritingHand, 1)
    add(intArrayOf(0x1f933), _Selfie)
    addVariations(intArrayOf(0x1f933, 0x0), _Selfie, 1)
    add(intArrayOf(0x1f485), _NailPolish)
    addVariations(intArrayOf(0x1f485, 0x0), _NailPolish, 1)
}

internal fun MutableList<Emoji>.addAllHandProp() {
    add(_WritingHand)
    add(_Selfie)
    add(_NailPolish)
}

/**
 * All Emoji of the People & Body: hand-prop subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHandProp(): List<Emoji> =
    ArrayList<Emoji>(3).apply { addAllHandProp() }
